/*********************************************************************  
    Scott Ashworth
    Josh Clinton
    Princeton University
    July 2006
    Code for "Does Advertising Affect Turnout?"
    New Jersey Sample	
*********************************************************************/

clear
use "NJ.Data.dta",replace

log using "Table5", replace text
/*	Table 6	*/
tabstat vote_2 advrt if bgmedmkt==0
tabstat vote_2 advrt if bgmedmkt==1
tab bgmedmkt
log close


log using "NJAppendix", replace text

/*	NJ Sample Descriptive Statistics	*/

sum if bgmedmkt==0			/*	NYC Market		*/
sum if bgmedmkt==1			/*	Philly Market	*/
ttest vote_1, by(bgmedmkt) unequal
ttest vote_2, by(bgmedmkt) unequal
ttest advrt, by(bgmedmkt) unequal
ttest pl_ntrst, by(bgmedmkt) unequal
ttest strngth_, by(bgmedmkt) unequal
ttest age, by(bgmedmkt) unequal
ttest female, by(bgmedmkt) unequal
ttest hispanic, by(bgmedmkt) unequal
ttest black, by(bgmedmkt) unequal
ttest union, by(bgmedmkt) unequal
ttest church, by(bgmedmkt) unequal

/******************************/
/*  	Table 6      		*/
/*	Appendix			*/
/******************************/
/*  OLS Results */
reg vote_2 advrt, robust     /*  Predicted Prob in text based on this */
reg vote_2 advrt if vote_1==0, robust
reg vote_2 advrt if vote_1==1, robust

/*  Wald Estimator */
ivreg vote_2 (advrt=bgmedmkt), robust
ivreg vote_2 (advrt=bgmedmkt) if vote_1==0, robust
ivreg vote_2 (advrt=bgmedmkt) if vote_1==1, robust


/******************************/
/*	Table 7 			*/
/*	Appendix			*/
/******************************/

reg vote_2 advrt strngth_  age if vote_1==1, robust 
reg vote_2 advrt strngth_  age if vote_1==0, robust 

reg advrt bgmedmkt strngth_  age if vote_1==0, robust 
ivreg vote_2 strngth_  age  (advrt = bgmedmkt) if vote_1==0, robust

/******************************/
/*	Table 8 			*/
/*	Appendix			*/
/******************************/

reg advrt bgmedmkt strngth_  age if vote_1==1, robust 
ivreg vote_2 strngth_  age  (advrt = bgmedmkt) if vote_1==1, robust
log close

